<?php

/**
 * Class that operate on table 'productionoutmanyoutproducts'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-01-24 21:04
 */
class ProductionoutmanyoutproductsMySqlDAO implements ProductionoutmanyoutproductsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductionoutmanyoutproductsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productionoutmanyoutproducts WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productionoutmanyoutproducts';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productionoutmanyoutproducts ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productionoutmanyoutproduct primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM productionoutmanyoutproducts WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductionoutmanyoutproductsMySql productionoutmanyoutproduct
     */
    public function insert($productionoutmanyoutproduct) {
        $sql = 'INSERT INTO productionoutmanyoutproducts (productionoutmanyid, productid, sizeid, colorid, prounitid, quantity, unitprice, cost) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionoutmanyoutproduct->productionoutmanyid);
        $sqlQuery->setNumber($productionoutmanyoutproduct->productid);
        $sqlQuery->setNumber($productionoutmanyoutproduct->sizeid);
        $sqlQuery->setNumber($productionoutmanyoutproduct->colorid);
        $sqlQuery->setNumber($productionoutmanyoutproduct->prounitid);
        $sqlQuery->set($productionoutmanyoutproduct->quantity);
        $sqlQuery->set($productionoutmanyoutproduct->unitprice);
        $sqlQuery->set($productionoutmanyoutproduct->cost);

        $id = $this->executeInsert($sqlQuery);
        $productionoutmanyoutproduct->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductionoutmanyoutproductsMySql productionoutmanyoutproduct
     */
    public function update($productionoutmanyoutproduct) {
        $sql = 'UPDATE productionoutmanyoutproducts SET productionoutmanyid = ?, productid = ?, sizeid = ?, colorid = ?, prounitid = ?, quantity = ?, unitprice = ?, cost = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionoutmanyoutproduct->productionoutmanyid);
        $sqlQuery->setNumber($productionoutmanyoutproduct->productid);
        $sqlQuery->setNumber($productionoutmanyoutproduct->sizeid);
        $sqlQuery->setNumber($productionoutmanyoutproduct->colorid);
        $sqlQuery->setNumber($productionoutmanyoutproduct->prounitid);
        $sqlQuery->set($productionoutmanyoutproduct->quantity);
        $sqlQuery->set($productionoutmanyoutproduct->unitprice);
        $sqlQuery->set($productionoutmanyoutproduct->cost);

        $sqlQuery->setNumber($productionoutmanyoutproduct->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productionoutmanyoutproducts';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductionoutmanyid($value) {
        $sql = 'SELECT * FROM productionoutmanyoutproducts WHERE productionoutmanyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM productionoutmanyoutproducts WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySizeid($value) {
        $sql = 'SELECT * FROM productionoutmanyoutproducts WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByColorid($value) {
        $sql = 'SELECT * FROM productionoutmanyoutproducts WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProunitid($value) {
        $sql = 'SELECT * FROM productionoutmanyoutproducts WHERE prounitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM productionoutmanyoutproducts WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnitprice($value) {
        $sql = 'SELECT * FROM productionoutmanyoutproducts WHERE unitprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCost($value) {
        $sql = 'SELECT * FROM productionoutmanyoutproducts WHERE cost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductionoutmanyid($value) {
        $sql = 'DELETE FROM productionoutmanyoutproducts WHERE productionoutmanyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM productionoutmanyoutproducts WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySizeid($value) {
        $sql = 'DELETE FROM productionoutmanyoutproducts WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByColorid($value) {
        $sql = 'DELETE FROM productionoutmanyoutproducts WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProunitid($value) {
        $sql = 'DELETE FROM productionoutmanyoutproducts WHERE prounitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM productionoutmanyoutproducts WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnitprice($value) {
        $sql = 'DELETE FROM productionoutmanyoutproducts WHERE unitprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCost($value) {
        $sql = 'DELETE FROM productionoutmanyoutproducts WHERE cost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductionoutmanyoutproductsMySql
     */
    protected function readRow($row) {
        $productionoutmanyoutproduct = new Productionoutmanyoutproduct();

        $productionoutmanyoutproduct->id = $row['id'];
        $productionoutmanyoutproduct->productionoutmanyid = $row['productionoutmanyid'];
        $productionoutmanyoutproduct->productid = $row['productid'];
        $productionoutmanyoutproduct->sizeid = $row['sizeid'];
        $productionoutmanyoutproduct->colorid = $row['colorid'];
        $productionoutmanyoutproduct->prounitid = $row['prounitid'];
        $productionoutmanyoutproduct->quantity = $row['quantity'];
        $productionoutmanyoutproduct->unitprice = $row['unitprice'];
        $productionoutmanyoutproduct->cost = $row['cost'];
        //
        $productionoutmanyoutproduct->productName = $row['productName'];
        $productionoutmanyoutproduct->productCatName = $row['productCatName'];
        $productionoutmanyoutproduct->sizeName = $row['sizeName'];
        $productionoutmanyoutproduct->colorName = $row['colorName'];
        $productionoutmanyoutproduct->productnumber = $row['productnumber'];
        $productionoutmanyoutproduct->unitName = $row['unitName'];

        return $productionoutmanyoutproduct;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductionoutmanyoutproductsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>